***** Is Europe an optimal Political Area?                *****
***** Alberto Alesina, Guido Tabellini & Francesco Trebbi *****

***** Section V -  EU vs US

*Set up 
clear all
set mem 10g
set matsize 11000
set more off



use "data/data_to_use_EU", clear
gen area="EU"
saveold "tmp_EU", replace

use "data/data_to_use_US_states", clear
gen area="US"
saveold "tmp_US_states", replace

append using tmp_EU
saveold tmp_all_states, replace
use tmp_all_states, clear

* Figure 13
kdensity cult_mdist if same==1 & area=="EU", addplot(kdensity cult_mdist if same==1 & area=="US", lw(medthick) lc(red) lp(solid)) ///
	legend(lab(1 "EU") label(2 "US")) lw(medthick) /// 
	lp(dash) lc(red) title("Cultural distance within countries and states") note("Extended set of cultural variables. Wave 4.") 
qui graph export "section5/figure_13c.png", replace

kdensity res_cult_mdist if same==1 & area=="EU", addplot(kdensity res_cult_mdist if same==1 & area=="US", lw(medthick) lc(red) lp(solid)) ///
	legend(lab(1 "EU") label(2 "US")) lw(medthick) /// 
	lp(dash) lc(red) title("Distance in residuals of culture within countries and states") note("Extended set of cultural variables. Wave 4.")
qui graph export "section5/figure_13d.png", replace

kdensity cult_mdist if same==0 & area=="EU", addplot(kdensity cult_mdist if same==0 & area=="US", lw(medthick) lc(red) lp(solid)) ///
	legend(lab(1 "EU") label(2 "US")) lw(medthick) /// 
	lp(dash) lc(red) title("Cultural distance between countries and states") note("Extended set of cultural variables. Wave 4.")
qui graph export "section5/figure_13e.png", replace
	
kdensity res_cult_mdist if same==0 & area=="EU", addplot(kdensity res_cult_mdist if same==0 & area=="US", lw(medthick) lc(red) lp(solid)) ///
	legend(lab(1 "EU") label(2 "US")) lw(medthick) /// 
	lp(dash) lc(red) title("Distance in residuals of culture between countries and states") note("Extended set of cultural variables. Wave 4.")
qui graph export "section5/figure_13f.png", replace

* Housekeeping
erase "data/data_to_use_EU.dta"
erase "data/data_to_use_US_states.dta"
erase "tmp_US_states.dta"
erase "tmp_all_states.dta"
erase "tmp_EU.dta"
